load('u1.mat')
load('u2.mat')

nt=100;
nx=100;
deltax=1/100;
deltat=1/100;
I = [ 0.5 , ones(1,nx-1) , 0.5 ];

%% preliminary integration to recover flagellum shapes from bending strains

r0 = zeros(3,nx+1,nt);
  
ds_r0 = zeros(3,nx+1,nt);

d1=zeros(3,nx+1);
d2=zeros(3,nx+1);
d3=zeros(3,nx+1);

 for inst=1:nt
 
d1(:,1)= [1;0;0];
d2(:,1)= [0;1;0];
d3(:,1)= [0;0;1];

d1norm(:,1)=[1;0;0];
d2norm(:,1)=[0;1;0];

for pts=1:nx

    d1(:,pts+1)= d1(:,pts) + deltax*( 0*d2(:,pts) - u2(pts,inst)*d3(:,pts) );
    d2(:,pts+1)= d2(:,pts) + deltax*( u1(pts,inst)*d3(:,pts) - 0*d1(:,pts) );
    
    d1norm(:,pts+1)= (d1(:,pts+1) - dot(d1(:,pts+1),d2(:,pts+1))*d2(:,pts+1))/norm(d1(:,pts+1) - dot(d1(:,pts+1),d2(:,pts+1))*d2(:,pts+1));
    d2norm(:,pts+1)= d2(:,pts+1)/norm(d2(:,pts+1));
  
    d1(:,pts+1)=d1norm(:,pts+1);
    d2(:,pts+1)=d2norm(:,pts+1);
    
    d3(:,pts+1)=cross(d1norm(:,pts+1),d2norm(:,pts+1));
    
end


for pts=1:nx

    r0(:,pts+1,inst)= r0(:,pts,inst) + deltax*d3(:,pts);    
        
end

for pts=1:(nx+1)

    ds_r0(:,pts,inst)= d3(:,pts);
    
end
 
 
 end

%% flagellum centerlines in cell body reference frame
 
% cell body dimensions wrt flagellum length L=1

rhoM=0.75;
rhom=rhoM*0.1728;

 
% flagellum orientation and placement parameters

thR0= 2.2 ;
psiR0= 4.6;
phR0= 2. ;
thd= 0.1;
phd= 6.2;


rbar=0*r0;


for inst=1:nt
rbar(1,:,inst) =  rhom*sin(thd)*sin(phd) + ...
                ( cos(thR0)*cos(psiR0) )*r0(1,:,inst) + ...
                (-cos(phR0)*sin(psiR0) + sin(phR0)*sin(thR0)*cos(psiR0) )*r0(2,:,inst) + ...
                ( sin(phR0)*sin(psiR0) + cos(phR0)*sin(thR0)*cos(psiR0) )*r0(3,:,inst);
 
rbar(2,:,inst) =  rhom*sin(thd)*cos(phd) + ...
                ( cos(thR0)*sin(psiR0) )*r0(1,:,inst) + ...
                ( cos(phR0)*cos(psiR0) + sin(phR0)*sin(thR0)*sin(psiR0) )*r0(2,:,inst) + ...
                (-sin(phR0)*cos(psiR0) + cos(phR0)*sin(thR0)*sin(psiR0) )*r0(3,:,inst);

rbar(3,:,inst) =  rhoM*cos(thd) + ...
                (-sin(thR0) )*r0(1,:,inst) + ...
                ( sin(phR0)*cos(thR0) )*r0(2,:,inst) + ...  
                ( cos(phR0)*cos(thR0) )*r0(3,:,inst);                                           
end


% flagellum velocity field (L=1 T=1) wrt body frame

dt_rbar=zeros(3,nx+1,nt);


for inst=1:(nt-1)
dt_rbar(:,:,inst)=(rbar(:,:,inst+1)-rbar(:,:,inst))/deltat;
end

dt_rbar(:,:,nt)=(rbar(:,:,1)-rbar(:,:,nt))/deltat;


% flagellum tangent wrt body frame

ds_rbar=0*ds_r0;


for inst=1:nt
ds_rbar(1,:,inst) = ( cos(thR0)*cos(psiR0) )*ds_r0(1,:,inst) + ...
                (-cos(phR0)*sin(psiR0) + sin(phR0)*sin(thR0)*cos(psiR0) )*ds_r0(2,:,inst) + ...
                ( sin(phR0)*sin(psiR0) + cos(phR0)*sin(thR0)*cos(psiR0) )*ds_r0(3,:,inst);
 
ds_rbar(2,:,inst) = ( cos(thR0)*sin(psiR0) )*ds_r0(1,:,inst) + ...
                ( cos(phR0)*cos(psiR0) + sin(phR0)*sin(thR0)*sin(psiR0) )*ds_r0(2,:,inst) + ...
                (-sin(phR0)*cos(psiR0) + cos(phR0)*sin(thR0)*sin(psiR0) )*ds_r0(3,:,inst);

ds_rbar(3,:,inst) = (-sin(thR0) )*ds_r0(1,:,inst) + ...
                ( sin(phR0)*cos(thR0) )*ds_r0(2,:,inst) + ...  
                ( cos(phR0)*cos(thR0) )*ds_r0(3,:,inst);                                           
end

%% Swimming

f=0*ds_rbar;
g=0*ds_rbar;

vbar=zeros(3,nt);
omegabar=zeros(3,nt);
fbar=zeros(3,nt);
gbar=zeros(3,nt);

Cort=3.5;
Cpar=Cort*0.05;

ecc=sqrt(rhoM^2-rhom^2)/rhoM;

Apar=  6*pi*rhoM*(8/3)*(ecc^3)/(-2*ecc + (1+ecc^2)*log((1+ecc)/(1-ecc))); 
Aort=  6*pi*rhoM*(16/3)*(ecc^3)/(2*ecc + (3*(ecc^2) -1 )*log((1+ecc)/(1-ecc))); 

Dpar=  8*pi*(rhoM^3)*(4/3)*(ecc^3)*(1-ecc^2)/(2*ecc - (1-ecc^2)*log((1+ecc)/(1-ecc))); 
Dort=  8*pi*(rhoM^3)*(4/3)*(ecc^3)*(2-ecc^2)/(-2*ecc + ((ecc^2) +1 )*log((1+ecc)/(1-ecc))); 


AB=[-Aort,0,0 ; 0,-Aort,0 ; 0,0,-Apar  ]; 
DB=[-Dort,0,0 ; 0,-Dort,0 ; 0,0,-Dpar  ]; 
Id=[1,0,0;0,1,0;0,0,1];

for inst=1:nt
% auxiliary functions
ds_rbar_dot_dt_rbar= ds_rbar(1,:,inst).*dt_rbar(1,:,inst) + ds_rbar(2,:,inst).*dt_rbar(2,:,inst) + ds_rbar(3,:,inst).*dt_rbar(3,:,inst) ; 

rbar_times_ds_rbar1= rbar(2,:,inst).*ds_rbar(3,:,inst) - rbar(3,:,inst).*ds_rbar(2,:,inst);
rbar_times_ds_rbar2= rbar(3,:,inst).*ds_rbar(1,:,inst) - rbar(1,:,inst).*ds_rbar(3,:,inst);
rbar_times_ds_rbar3= rbar(1,:,inst).*ds_rbar(2,:,inst) - rbar(2,:,inst).*ds_rbar(1,:,inst);

int_rbarx= [           0              , -deltax*I*rbar(3,:,inst)' ,  deltax*I*rbar(2,:,inst)' ;
             deltax*I*rbar(3,:,inst)' ,           0               , -deltax*I*rbar(1,:,inst)' ;
            -deltax*I*rbar(2,:,inst)' ,  deltax*I*rbar(1,:,inst)' ,           0               ];
        
int_rbarxSQRD= [ deltax*I*(- rbar(2,:,inst).^2 - rbar(3,:,inst).^2 )' ,      deltax*I*(rbar(1,:,inst).*rbar(2,:,inst))'       ,      deltax*I*(rbar(1,:,inst).*rbar(3,:,inst))'      ;    
                    deltax*I*(rbar(1,:,inst).*rbar(2,:,inst))'        , deltax*I*(- rbar(1,:,inst).^2 - rbar(3,:,inst).^2 )'  ,      deltax*I*(rbar(2,:,inst).*rbar(3,:,inst))'      ;
                    deltax*I*(rbar(1,:,inst).*rbar(3,:,inst))'        ,      deltax*I*(rbar(2,:,inst).*rbar(3,:,inst))'       ,   deltax*I*(- rbar(1,:,inst).^2 - rbar(2,:,inst).^2 )'   ];        

% fbar field
f(1,:,inst)= - Cort*dt_rbar(1,:,inst) - (Cpar - Cort)*ds_rbar(1,:,inst).*ds_rbar_dot_dt_rbar;
f(2,:,inst)= - Cort*dt_rbar(2,:,inst) - (Cpar - Cort)*ds_rbar(2,:,inst).*ds_rbar_dot_dt_rbar;
f(3,:,inst)= - Cort*dt_rbar(3,:,inst) - (Cpar - Cort)*ds_rbar(3,:,inst).*ds_rbar_dot_dt_rbar;

% fbar
fbar(1,inst) = deltax*I*f(1,:,inst)';
fbar(2,inst) = deltax*I*f(2,:,inst)';
fbar(3,inst) = deltax*I*f(3,:,inst)';

% gbar field
g(1,:,inst) = rbar(2,:,inst).*f(3,:,inst) - rbar(3,:,inst).*f(2,:,inst) ;
g(2,:,inst) = rbar(3,:,inst).*f(1,:,inst) - rbar(1,:,inst).*f(3,:,inst) ;
g(3,:,inst) = rbar(1,:,inst).*f(2,:,inst) - rbar(2,:,inst).*f(1,:,inst) ;

% gbar
gbar(1,inst) = deltax*I*g(1,:,inst)';
gbar(2,inst) = deltax*I*g(2,:,inst)';
gbar(3,inst) = deltax*I*g(3,:,inst)';

% resistive matrix

AF = - Cort*Id - (Cpar - Cort)*[ deltax*I*(ds_rbar(1,:,inst).*ds_rbar(1,:,inst))' , deltax*I*(ds_rbar(1,:,inst).*ds_rbar(2,:,inst))' , deltax*I*(ds_rbar(1,:,inst).*ds_rbar(3,:,inst))'  ;
                                 deltax*I*(ds_rbar(2,:,inst).*ds_rbar(1,:,inst))' , deltax*I*(ds_rbar(2,:,inst).*ds_rbar(2,:,inst))' , deltax*I*(ds_rbar(2,:,inst).*ds_rbar(3,:,inst))'  ; 
                                 deltax*I*(ds_rbar(3,:,inst).*ds_rbar(1,:,inst))' , deltax*I*(ds_rbar(3,:,inst).*ds_rbar(2,:,inst))' , deltax*I*(ds_rbar(3,:,inst).*ds_rbar(3,:,inst))'    ] ; 
 
BF = Cort*int_rbarx - (Cpar - Cort)*[ deltax*I*(ds_rbar(1,:,inst).*rbar_times_ds_rbar1)' , deltax*I*(ds_rbar(1,:,inst).*rbar_times_ds_rbar2)' , deltax*I*(ds_rbar(1,:,inst).*rbar_times_ds_rbar3)'  ;
                                      deltax*I*(ds_rbar(2,:,inst).*rbar_times_ds_rbar1)' , deltax*I*(ds_rbar(2,:,inst).*rbar_times_ds_rbar2)' , deltax*I*(ds_rbar(2,:,inst).*rbar_times_ds_rbar3)'  ; 
                                      deltax*I*(ds_rbar(3,:,inst).*rbar_times_ds_rbar1)' , deltax*I*(ds_rbar(3,:,inst).*rbar_times_ds_rbar2)' , deltax*I*(ds_rbar(3,:,inst).*rbar_times_ds_rbar3)'    ] ; 
 
DF = Cort*int_rbarxSQRD - (Cpar - Cort)*[ deltax*I*(rbar_times_ds_rbar1.*rbar_times_ds_rbar1)' , deltax*I*(rbar_times_ds_rbar1.*rbar_times_ds_rbar2)' , deltax*I*(rbar_times_ds_rbar1.*rbar_times_ds_rbar3)'  ;
                                          deltax*I*(rbar_times_ds_rbar2.*rbar_times_ds_rbar1)' , deltax*I*(rbar_times_ds_rbar2.*rbar_times_ds_rbar2)' , deltax*I*(rbar_times_ds_rbar2.*rbar_times_ds_rbar3)'  ; 
                                          deltax*I*(rbar_times_ds_rbar3.*rbar_times_ds_rbar1)' , deltax*I*(rbar_times_ds_rbar3.*rbar_times_ds_rbar2)' , deltax*I*(rbar_times_ds_rbar3.*rbar_times_ds_rbar3)'    ] ; 

           
% resistive matrix blocks

A = AB + AF ;
B = BF ;
D = DB + DF ;

vbar_omegabar = - [ A , B ; B' , D]\[ fbar(:,inst) ; gbar(:,inst) ];

vbar(:,inst)= vbar_omegabar(1:3);
omegabar(:,inst)= vbar_omegabar(4:6);

end 


%% integrating c and Q

c0=zeros(3,nt+1);

angQ0=zeros(3,nt+1);
i0=zeros(3,nt+1);
j0=zeros(3,nt+1);
k0=zeros(3,nt+1);

for inst=1:nt

    if norm(angQ0(:,inst))<0.0001
    angQ0(:,inst+1)=  angQ0(:,inst)+ deltat*omegabar(:,inst);
    
    else
    
  angQ0(:,inst+1)=  angQ0(:,inst)+ deltat*( omegabar(:,inst) + ...
                          0.5*cross(angQ0(:,inst),omegabar(:,inst))  -  ...
    (( norm(angQ0(:,inst))*cot(norm(angQ0(:,inst))/2) -2 )/(2*(norm(angQ0(:,inst))^2))   )*cross(angQ0(:,inst),cross(angQ0(:,inst),omegabar(:,inst)))   );
    end
end

for inst=1:(nt+1)

    if norm(angQ0(:,inst))<0.0001
    i0(:,inst)=  [ 1 , 0 , 0 ]';
    j0(:,inst)=  [ 0 , 1 , 0 ]';
    k0(:,inst)=  [ 0 , 0 , 1 ]';
       else
    i0(:,inst)=  [ 1 , 0 , 0 ]' +  (sin(norm(angQ0(:,inst)))/norm(angQ0(:,inst)))*cross(angQ0(:,inst),[ 1 , 0 , 0]')  + ((1 - cos(norm(angQ0(:,inst))))/(norm(angQ0(:,inst))^2))*cross(angQ0(:,inst),cross(angQ0(:,inst),[1 ,0 ,0]'))  ;
    j0(:,inst)=  [ 0 , 1 , 0 ]' +  (sin(norm(angQ0(:,inst)))/norm(angQ0(:,inst)))*cross(angQ0(:,inst),[ 0 , 1 , 0]')  + ((1 - cos(norm(angQ0(:,inst))))/(norm(angQ0(:,inst))^2))*cross(angQ0(:,inst),cross(angQ0(:,inst),[0 ,1 ,0]'))  ;
    k0(:,inst)=  [ 0 , 0 , 1 ]' +  (sin(norm(angQ0(:,inst)))/norm(angQ0(:,inst)))*cross(angQ0(:,inst),[ 0 , 0 , 1]')  + ((1 - cos(norm(angQ0(:,inst))))/(norm(angQ0(:,inst))^2))*cross(angQ0(:,inst),cross(angQ0(:,inst),[0 ,0 ,1]'))  ;
    
    end
    
end

for inst=2:(nt+1)
c0(:,inst)= c0(:,inst-1) + deltat*[i0(:,inst-1) , j0(:,inst-1) , k0(:,inst-1)  ]*vbar(:,inst-1);
end



%% extension 

nbeats= 90;


Q=zeros(3,3,nt*nbeats+1);
c=zeros(3,nt*nbeats+1);
c_lab=zeros(3,nt*nbeats+1);
Q_lab=zeros(3,3,nt*nbeats+1);


for inst=1:nt
    Q(:,:,inst)=[i0(:,inst) , j0(:,inst) , k0(:,inst)  ];
end
for inst=1:(nt+1)
    c(:,inst)=c0(:,inst);
end

for beat=1:(nbeats-1)
for inst=1:(nt+1)
    Q(:,:,beat*nt + inst)=[i0(:,nt+1) , j0(:,nt+1) , k0(:,nt+1)  ]*Q(:,:,(beat-1)*nt + inst);
end
end

for beat=1:(nbeats-1)
for inst=1:(nt+1)
    c(:,beat*nt + inst)= c(:,beat*nt +1) + [i0(:,nt+1) , j0(:,nt+1) , k0(:,nt+1)  ]*(c(:,(beat-1)*nt + inst) -c(:,(beat-1)*nt + 1));
end
end


n_unit=angQ0(:,nt+1)/norm(angQ0(:,nt+1));
m_unit=cross(n_unit,[1 ; 0 ; 0])/norm(cross(n_unit,[1 0 0]));
l_unit=cross(m_unit,n_unit);

for inst=1:(nt*nbeats+1)
c_lab(:,inst)=([l_unit , m_unit , n_unit ]')*c(:,inst);
Q_lab(:,:,inst)=([l_unit , m_unit , n_unit ]')*Q(:,:,inst);
end

%% plots

figure


subplot(1,8,[1 2]);

plot(deltat*(1:nt),vbar(1,:),'r-')
hold on
plot(deltat*(1:nt),vbar(2,:),'y-')
plot(deltat*(1:nt),vbar(3,:),'b-')
hold off
grid on
xlabel('t / T')
ylabel('v / L T^{-1}')
xlim([0,1])
ylim([-0.1 0.08])
legend('v \cdot i','v \cdot j','v \cdot k','Location','southwest')

subplot(1,8,[4 5]);

plot(deltat*(1:nt),omegabar(1,:),'r-')
hold on
plot(deltat*(1:nt),omegabar(2,:),'y-')
plot(deltat*(1:nt),omegabar(3,:),'b-')
hold off
grid on
xlabel('t / T')
ylabel('\omega / T^{-1}')
xlim([0,1])
ylim([-0.2 1.1])
legend('\omega \cdot i','\omega \cdot j','\omega \cdot k','Location','northwest')

subplot(1,8,[7 8] );

plot3(c_lab(1,:),c_lab(2,:),c_lab(3,:),'r-')
daspect([ 1 , 1 , 1])
grid on
title('c')
xlabel('x/L')
ylabel('y/L')
zlabel('z/L')